IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_SCA_ValidarClientes_Links]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_SCA_ValidarClientes_Links] 
END
GO

CREATE PROCEDURE [dbo].[CP_SCA_ValidarClientes_Links]	@pId_Cliente						INT, 
														@pId_Acceso							SMALLINT, 
														@pFecha								DATETIME, 
														@pTipoAcceso						CHAR(1), 
														@pFechaEvento						DATETIME,
														@Flag_ValidarClientes_Link_Rta		TINYINT OUTPUT
AS
BEGIN
DECLARE @Flag_Valida_Links	TINYINT
DECLARE @Id_Link_Habilitado INT


SET @Flag_Valida_Links = ISNULL((SELECT ISNULL(Flag_Clientes_Links_Validar, 0) FROM CD_Accesos WHERE Id_Acceso = @pId_Acceso), 0)


IF(@Flag_Valida_Links = 1) 
BEGIN
	SET @Id_Link_Habilitado = ISNULL((	SELECT MIN(Id_Link) 
										FROM Clientes_Links 
										WHERE 
										Id_Cliente = @pId_Cliente 
										AND Fecha_Desde <= @pFecha
										AND (Fecha_Hasta IS NULL OR Fecha_Hasta >= @pFecha)
										AND (Cant_Usos_Permitidos - Cant_Usos_Realizados) > 0
										)
									, 0) 

	IF(@Id_Link_Habilitado > 0)
	BEGIN
		UPDATE Clientes_Links
		SET
		Cant_Usos_Realizados = Cant_Usos_Realizados + 1,
		Fecha_Ult_Uso = GETDATE()
		WHERE
		Id_Link = @Id_Link_Habilitado		

		SET @Flag_ValidarClientes_Link_Rta = 1
	END
	ELSE
	BEGIN
		SET @Flag_ValidarClientes_Link_Rta = 0
	END
END
ELSE
BEGIN
	/*No valida Clientes_Links*/
	SET @Flag_ValidarClientes_Link_Rta = 0
END

RETURN ISNULL(@Flag_ValidarClientes_Link_Rta, 0)
END
